/*****************************************************************************
*  LPC15xx demoprogram for MicroCore100 rev A board
*
*  1. Use SCT0 timer to generate a 100 usec clock output @ SCT0_OUT0 (5KHz)
*  2. SCT0_OUT0 is linked to P0_7 (toggles every 100 usec)
*  3. Input clock to the SCT is the SCT PLL running at 156 MHz
*****************************************************************************/
#include "LPC15xx.h"

extern void SCT0_Init(void);

int main (void) 
{
    LPC_SWM->PINASSIGN7 |= 0x0000FF00;             // ASSIGN7(15:8) = FF
    LPC_SWM->PINASSIGN7 &= 0xFFFF07FF;             // P0_7 is SCT0_OUT0, ASSIGN7(15:8)

    LPC_SYSCON->PDRUNCFG    &= ~PDEN_SCT_PLL;      // power-up SCT PLL
    LPC_SYSCON->SCTPLLCLKSEL = 0;                  // select SCT PLL input = IRC
    LPC_SYSCON->SCTPLLCTRL   = (12 << 0) |         // MSEL = 12 -> M = MSEL + 1 = 13
                               (0  << 6);          // PSEL = 0 -> P = 1
    while (!(LPC_SYSCON->SCTPLLSTAT & 0x01));      // wait until SCT PLL locked

    SCT0_Init();                                   // Initialize SCT

    while (1) 
    {
    }
}
